# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .nats_user_password_auth import NatsUserPasswordAuth


class NatsInputConfig(UniversalBaseModel):
    """
    +docs=Describes the configuration for the input NATS worker
    +label=NATS
    """

    type: typing.Literal["nats"] = pydantic.Field(default="nats")
    """
    +value=nats
    """

    nats_url: str = pydantic.Field()
    """
    +label=NATS URL
    +usage=Input NATS URL
    +sort=1
    """

    stream_name: str = pydantic.Field()
    """
    +label=Stream Name
    +usage=Name of the NATS stream
    +sort=2
    """

    root_subject: str = pydantic.Field()
    """
    +label=Root Subject
    +usage=Root subject of input NATS
    +message=Input NATS root subject should only contain alphanumeric letters, dashes(-), and periods(.)
    +sort=3
    """

    consumer_name: str = pydantic.Field()
    """
    +label=Consumer Name
    +usage=Consumer name of input NATS
    +message=Consumer name should only contain alphanumeric letters, dashes(-), and underscores(_)
    +sort=4
    """

    wait_time_seconds: int = pydantic.Field(default=19)
    """
    +label=Wait Time Seconds
    +usage=Wait timeout for long polling.
    +sort=5
    """

    nats_metrics_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=NATS metrics URL
    +usage=URL for the NATS metrics endpoint. It is compulsory if you want to use NATS autoscaling.
    +message=NATS Metrics URL should be a valid HTTP/HTTPS URL
    """

    auth: typing.Optional[NatsUserPasswordAuth] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
