# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .nats_user_password_auth import NatsUserPasswordAuth


class NatsOutputConfig(UniversalBaseModel):
    """
    +docs=Describes the configuration for the output NATS worker
    +label=NATS
    """

    type: typing.Literal["nats"] = pydantic.Field(default="nats")
    """
    +value=nats
    """

    nats_url: str = pydantic.Field()
    """
    +label=NATS URL
    +usage=Output NATS URL
    +sort=1
    """

    root_subject: str = pydantic.Field()
    """
    +label=Root Subject
    +usage=Root subject of output NATS
    +message=Output NATS root subject should only contain alphanumeric letters, dashes(-), and periods(.)
    +sort=2
    """

    auth: typing.Optional[NatsUserPasswordAuth] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
