# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class NatsUserPasswordAuth(UniversalBaseModel):
    """
    +docs=NATS User Password Authentication
    +label=NATS User Password Authentication
    """

    account_name: str = pydantic.Field(default="$G")
    """
    +label=Account Name
    +usage=Name of the NATS account
    +sort=1
    """

    user: str = pydantic.Field()
    """
    +label=User
    +usage=User for NATS authentication
    +sort=2
    """

    password: str = pydantic.Field()
    """
    +label=Password
    +usage=Password for NATS authentication
    +sort=3
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
