# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .nomic_integrations import NomicIntegrations
from .nomic_key_auth import NomicKeyAuth


class NomicProviderAccount(UniversalBaseModel):
    """
    +label=Nomic Provider Account
    +icon=nomic
    """

    type: typing.Literal["provider-account/nomic"] = pydantic.Field(default="provider-account/nomic")
    """
    +value=provider-account/nomic
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the Nomic provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    auth_data: NomicKeyAuth
    integrations: typing.Optional[typing.List[NomicIntegrations]] = pydantic.Field(default=None)
    """
    +label=Integrations
    +sort=300
    +usage=List of integrations that are associated with the Nomic provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=400
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
