# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class NvidiaGpu(UniversalBaseModel):
    type: typing.Literal["nvidia_gpu"] = pydantic.Field(default="nvidia_gpu")
    """
    +value=nvidia_gpu
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=GPU Name
    +usage=Name of the Nvidia GPU. One of [P4, P100, V100, T4, A10G, A100_40GB, A100_80GB]
    This field is required for Node Selector and can be ignored in Nodepool Selector.
    One instance of the card contains the following amount of memory -
    P4: 8 GB, P100: 16 GB, V100: 16 GB, T4: 16 GB, A10G: 24 GB, A100_40GB: 40GB, A100_80GB: 80 GB
    """

    count: int = pydantic.Field()
    """
    +label=GPU Count
    +usage=Count of GPUs to provide to the application
    Note the exact count and max count available for a given GPU type depends on cloud provider and cluster type.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
