# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .nvidia_miggpu_profile import NvidiaMiggpuProfile


class NvidiaMiggpu(UniversalBaseModel):
    type: typing.Literal["nvidia_mig_gpu"] = pydantic.Field(default="nvidia_mig_gpu")
    """
    +value=nvidia_mig_gpu
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=GPU Name
    +usage=Name of the Nvidia GPU. One of [P4, P100, V100, T4, A10G, A100_40GB, A100_80GB]
    This field is required for Node Selector and can be ignored in Nodepool Selector.
    One instance of the card contains the following amount of memory -
    P4: 8 GB, P100: 16 GB, V100: 16 GB, T4: 16 GB, A10G: 24 GB, A100_40GB: 40GB, A100_80GB: 80 GB
    """

    profile: NvidiaMiggpuProfile = pydantic.Field()
    """
    +label=MIG Profile
    +usage=Name of the MIG profile to use. One of the following based on gpu type
    Please refer to https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#supported-mig-profiles for more details
    A30 - [1g.6gb, 2g.12gb, 4g.24gb]
    A100 40 GB - [1g.5gb, 1g.10gb, 2g.10gb, 3g.20gb, 4g.20gb, 7g.40gb]
    A100 80 GB / H100 80 GB - [1g.10gb, 1g.20gb, 2g.20gb, 3g.40gb, 4g.40gb, 7g.80gb]
    H100 94 GB - [1g.12gb, 1g.24gb, 2g.24gb, 3g.47gb, 4g.47gb, 7g.94gb]
    H100 96 GB - [1g.12gb, 1g.24gb, 2g.24gb, 3g.48gb, 4g.48gb, 7g.96gb]
    H200 141 GB - [1g.18gb, 1g.35gb, 2g.35gb, 3g.71gb, 4g.71gb]
    B200 180 GB - [1g.23gb, 1g.45gb, 2g.45gb, 3g.90gb, 4g.90gb, 7g.180gb]
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
