# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class OciRepo(UniversalBaseModel):
    """
    +label=OCIRepo
    """

    type: typing.Literal["oci-repo"] = pydantic.Field(default="oci-repo")
    """
    +value=oci-repo
    """

    oci_chart_url: str = pydantic.Field()
    """
    +label=OCI chart URL
    +message=Need to be a valid URL.
    """

    integration_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +docs=FQN of the container registry. You can use the FQN of your desired container registry (or add one)
    in the  Integrations page[Integrations](https://app.truefoundry.tech/integrations) page
    +label=Container Registry
    +usage=FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations) page
    +uiType=IntegrationSelect
    +uiProps={"integrationType":"docker-registry"}
    """

    version: str = pydantic.Field()
    """
    +label=Version
    +usage=Helm chart version
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
