# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .open_ai_moderations_guardrail_config_category_thresholds_value import (
    OpenAiModerationsGuardrailConfigCategoryThresholdsValue,
)
from .openai_api_key_auth import OpenaiApiKeyAuth


class OpenAiModerationsGuardrailConfig(UniversalBaseModel):
    """
    +label=OpenAI Moderation
    +icon=openai
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=50
    +usage=The name of the Guardrail Config.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    type: typing.Literal["integration/guardrail-config/openai-moderations"] = pydantic.Field(
        default="integration/guardrail-config/openai-moderations"
    )
    """
    +value=integration/guardrail-config/openai-moderations
    +sort=50
    +uiType=Hidden
    """

    base_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Base URL
    +sort=100
    +usage=Optional custom base URL for OpenAI API. If not provided, the default base URL will be used.
    """

    auth_data: OpenaiApiKeyAuth
    model: str = pydantic.Field(default="omni-moderation-latest")
    """
    +label=OpenAI Moderation Model
    +sort=300
    +usage=The model to use for the OpenAI Moderation API.
    """

    category_thresholds: typing.Optional[typing.Dict[str, OpenAiModerationsGuardrailConfigCategoryThresholdsValue]] = (
        pydantic.Field(default=None)
    )
    """
    +label=Category Thresholds
    +sort=400
    +usage=The thresholds for the OpenAI Moderation API.
    +uiType=KV
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
