# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .pager_duty_integration_key_auth import PagerDutyIntegrationKeyAuth


class PagerDutyIntegration(UniversalBaseModel):
    """
    +label=PagerDuty Integration
    +icon=https://assets.production.truefoundry.com/pagerduty.png
    """

    type: typing.Literal["integration/notification-channel/pagerduty"] = pydantic.Field(
        default="integration/notification-channel/pagerduty"
    )
    """
    +value=integration/notification-channel/pagerduty
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +sort=100
    +usage=The name of the integration that will be displayed in the TrueFoundry UI.
    +uiProps={"disableEdit":false}
    """

    auth_data: PagerDutyIntegrationKeyAuth
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=10005
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
