# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .pager_duty_integrations import PagerDutyIntegrations


class PagerDutyProviderAccount(UniversalBaseModel):
    """
    +label=PagerDuty Provider Account
    +icon=https://assets.production.truefoundry.com/pagerduty.png
    """

    type: typing.Literal["provider-account/pagerduty"] = pydantic.Field(default="provider-account/pagerduty")
    """
    +value=provider-account/pagerduty
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the PagerDuty provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    integrations: typing.List[PagerDutyIntegrations] = pydantic.Field()
    """
    +label=Integrations
    +sort=500
    +usage=List of integrations that are associated with the PagerDuty provider account
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
