# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .palo_alto_prisma_airs_guardrail_config_mode import PaloAltoPrismaAirsGuardrailConfigMode
from .palo_alto_prisma_airs_key_auth import PaloAltoPrismaAirsKeyAuth


class PaloAltoPrismaAirsGuardrailConfig(UniversalBaseModel):
    """
    +label=Palo Alto Prisma AIRS
    +icon=https://assets.production.truefoundry.com/palo-alto-prisma-airs.svg
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=50
    +usage=The name of the Guardrail Config.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    type: typing.Literal["integration/guardrail-config/palo-alto-prisma-airs"] = pydantic.Field(
        default="integration/guardrail-config/palo-alto-prisma-airs"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/palo-alto-prisma-airs
    """

    profile_name: str = pydantic.Field()
    """
    +label=Profile Name
    +usage=The profile name associated with this Guardrail Config.
    +sort=60
    """

    mode: typing.Optional[PaloAltoPrismaAirsGuardrailConfigMode] = pydantic.Field(default=None)
    """
    +label=Mode
    +usage=Execution mode for the guardrail. Sync waits for the guardrail check to complete before proceeding. Async triggers the check without waiting. Defaults to sync.
    +sort=70
    +uiType=Select
    """

    auth_data: PaloAltoPrismaAirsKeyAuth

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
