# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .pangea_guard_type import PangeaGuardType
from .pangea_key_auth import PangeaKeyAuth


class PangeaGuardrailConfig(UniversalBaseModel):
    """
    +label=Pangea
    +icon=https://assets.production.truefoundry.com/pangea-logo.svg
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=50
    +usage=The name of the Guardrail Config.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    type: typing.Literal["integration/guardrail-config/pangea"] = pydantic.Field(
        default="integration/guardrail-config/pangea"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/pangea
    """

    auth_data: PangeaKeyAuth
    guard_type: PangeaGuardType
    domain: str = pydantic.Field()
    """
    +label=Domain
    +usage=Domain of the cloud provider and region where your Pangea project is configured. Example: if endpoint is: https://<service_name>.aws.us-west-2.pangea.cloud/v1/text/guard, the input should be: aws.us-west-2.pangea.cloud
    +message=Must be a valid domain name.
    +sort=200
    """

    recipe: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Recipe
    +usage=Recipe key of a configuration of data types and settings defined in the Pangea User Console. It specifies the rules that are to be applied to the text, such as defang malicious URLs.
    +sort=200
    """

    overrides: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +label=Overrides
    +usage=Overrides for the Pangea account
    +sort=300
    +uiType=KV
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
