# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .param_param_type import ParamParamType


class Param(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    +usage=Name of the param
    +message=name can contain lower case alphabets, digits, underscore (_) and hypen (-). It can be 32 characters long, should start with an alphabet, and should end with either an alphabet or digit.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    +usage=Description of param
    +message=description cannot be longer than 127 characters
    """

    default: typing.Optional[str] = pydantic.Field(default=None)
    """
    +usage=Default value or placeholder
    +message=default value cannot be longer than 127 characters
    +label=Default value
    """

    param_type: typing.Optional[ParamParamType] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
