# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .patronus_evaluator import PatronusEvaluator
from .patronus_guardrail_config_target import PatronusGuardrailConfigTarget
from .patronus_key_auth import PatronusKeyAuth


class PatronusGuardrailConfig(UniversalBaseModel):
    """
    +label=Patronus
    +icon=https://assets.production.truefoundry.com/patronus.svg
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=50
    +usage=The name of the Guardrail Config.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    type: typing.Literal["integration/guardrail-config/patronus"] = pydantic.Field(
        default="integration/guardrail-config/patronus"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/patronus
    """

    auth_data: PatronusKeyAuth
    target: PatronusGuardrailConfigTarget = pydantic.Field()
    """
    +label=Target
    +usage=The type of request to use for the Patronus Guardrail.
    +sort=100
    +uiType=Select
    """

    evaluators: typing.List[PatronusEvaluator] = pydantic.Field()
    """
    +label=Evaluators
    +usage=The evaluators to use for the Patronus Guardrail.
    +sort=200
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
