# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class Permissions(UniversalBaseModel):
    resource_fqn: str = pydantic.Field()
    """
    +label= Resource FQN
    +usage=The fully qualified name of the resource
    """

    resource_type: str = pydantic.Field()
    """
    +label=Resource Type
    +usage=The type of the resource (cluster, workspace, etc.)
    """

    role_id: str = pydantic.Field()
    """
    +label=Role ID
    +usage=The role id of the role to be assigned to the service account for that resource
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
