# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class PersonalAccessTokenManifest(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    +label=Name
    +sort=1
    +message=3 to 25 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +usage=Personal Access Token Name
    """

    type: typing.Literal["pat"] = pydantic.Field(default="pat")
    """
    +value=pat
    """

    expiration_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Expiration Date (UTC)
    +sort=2
    +message=Expiration date of the personal access token
    +usage=Expiration Date of the Personal Access Token (should be in the ISO 8601 format)
    +uiType=DatePicker
    """

    user_fqn: str = pydantic.Field()
    """
    +label=User FQN
    +sort=3
    +usage=The fully qualified name of the user
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
