# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .alert_severity import AlertSeverity


class PrometheusAlertRule(UniversalBaseModel):
    """
    +label=Prometheus Alert Rule
    """

    type: typing.Literal["prometheus-alert-rule"] = pydantic.Field(default="prometheus-alert-rule")
    """
    +label=Type
    +value=prometheus-alert-rule
    +uiType=Hidden
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +usage=Enter a unique, descriptive name for your Prometheus alert rule. Choose a name that clearly indicates the condition being monitored. Please note that reserved alert names for TrueFoundry managed alerts are not allowed. For checking the list of reserved alert names, please refer to the documentation.
    +uiProps={"descriptionInline":true}
    +message=3 to 35 alphanumeric characters long, can contain - in between, cannot start with a number and cannot end with a -
    +sort=1
    """

    expression: str = pydantic.Field()
    """
    +label=Prometheus Expression
    +usage=Enter a valid PromQL expression that defines the condition for triggering this alert. The alert will fire when this expression evaluates to true for the duration specified in the duration to trigger alert field.
    +uiProps={"descriptionInline":true, "language": "promql"}
    +placeholder=sum(increase(container_cpu_cfs_throttled_periods_total{container="postgresql", namespace="prod-ws"}[5m])) by (container, namespace) / sum(increase(container_cpu_cfs_periods_total[5m])) by (container, namespace) > ( 25 / 100 )
    +sort=3
    +uiType=CodeEditor
    """

    for_: typing_extensions.Annotated[float, FieldMetadata(alias="for")] = pydantic.Field()
    """
    +label=Trigger After (seconds)
    +placeholder=300
    +usage=The prometheus expression must remain true for this duration (in seconds) before the alert is triggered. If the condition becomes false before this time elapses, the alert will not fire.
    +sort=4
    """

    severity: AlertSeverity
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Description
    +usage=Description of the alert rule which will be displayed in the alert rule list. This can be used to provide more context about the alert rule.
    +uiProps={"descriptionInline":true}
    +placeholder=CPU throttled for more than 25% of the time in the last 5 minutes for
    +sort=2
    """

    notification_enabled: bool = pydantic.Field(default=True)
    """
    +label=Notification Enabled
    +usage=When enabled, notifications will be sent to all configured target channels when the alert conditions are met.
    +uiProps={"descriptionInline":true}
    +sort=7
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
