# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .spark_driver_config import SparkDriverConfig
from .spark_executor_config import SparkExecutorConfig
from .task_py_spark_build import TaskPySparkBuild
from .volume_mount import VolumeMount


class PySparkTaskConfig(UniversalBaseModel):
    type: typing.Literal["pyspark-task-config"] = pydantic.Field(default="pyspark-task-config")
    """
    +value=pyspark-task-config
    """

    image: TaskPySparkBuild
    driver_config: SparkDriverConfig
    executor_config: SparkExecutorConfig
    spark_conf: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    +label=Spark Config Properties
    +usage=Extra configuration properties to be passed to the spark job. [Docs](https://spark.apache.org/docs/latest/configuration.html)
    +icon=fa-gear:#68BBE3
    +sort=3000
    """

    env: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    +label=Environment Variables
    +usage=Configure environment variables to be injected in the task either as plain text or secrets. [Docs](https://docs.truefoundry.com/docs/env-variables)
    +icon=fa-globe
    +sort=4000
    """

    mounts: typing.Optional[typing.List[VolumeMount]] = pydantic.Field(default=None)
    """
    +usage=Configure data to be mounted to Workflow pod(s) as a volume.
    +sort=5000
    """

    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Service Account
    +sort=6000
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
