# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .python_build_command import PythonBuildCommand
from .python_build_python_dependencies import PythonBuildPythonDependencies


class PythonBuild(UniversalBaseModel):
    """
    +docs=Describes that we are using python to build a container image with a specific python version and pip packages installed.
    +label=Python Code (I don't have Dockerfile)
    +icon=fa-brands fa-python:#306998
    """

    type: typing.Literal["tfy-python-buildpack"] = pydantic.Field(default="tfy-python-buildpack")
    """
    +value=tfy-python-buildpack
    """

    python_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Python version
    +usage=Python version to run your application. Should be one of the tags listed on [Official Python Docker Page](https://hub.docker.com/_/python)
    +message=Please enter a valid Python version tag
    +sort=10002
    """

    build_context_path: str = pydantic.Field(default="./")
    """
    +label=Path to build context
    +usage=Build path relative to project root path.
    +sort=10000
    """

    requirements_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    `Path to build context`
    +label=Path to requirements
    +usage=Path to `requirements.txt` relative to
    `Path to build context`
    +uiType=Hidden
    +sort=10004
    """

    pip_packages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Pip packages to install
    +usage=Define pip package requirements.
    In Python/YAML E.g. ["fastapi>=0.90,<1.0", "uvicorn"]
    +placeholder=Enter a pip package name E.g. fastapi>=0.90,<1.0
    +uiType=Hidden
    """

    python_dependencies: typing.Optional[PythonBuildPythonDependencies] = pydantic.Field(default=None)
    """
    +label=Python dependencies
    +usage=Python dependencies to install
    +sort=10004
    """

    apt_packages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=List of Debian packages to install.
    +usage=Debian packages to install via `apt get`.
    In Python/YAML E.g. ["git", "ffmpeg", "htop"]
    +placeholder=Enter a debian package name E.g. ffmpeg
    """

    command: PythonBuildCommand = pydantic.Field()
    """
    Command will be set as the Entrypoint of the generated
    image.
    +label=Command
    +usage=Command to run when the container starts.
    Command will be set as the Entrypoint of the generated image.
    When deploying a Job, the command can be templatized by defining `params` and referencing them in command
    E.g. `python main.py --learning_rate {{learning_rate}}`
    +sort=10001
    """

    cuda_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=CUDA Version
    +usage=Version of CUDA Toolkit and CUDNN to install in the image
    These combinations are based off of publically available docker images on docker hub
    You can also specify a valid tag of the form {cuda_version_number}-cudnn{cudnn_version_number}-{runtime|devel}-ubuntu{ubuntu_version}
    Refer https://hub.docker.com/r/nvidia/cuda/tags for valid set of values
    Note: We use deadsnakes ubuntu ppa to add Python that currently supports only Ubuntu 18.04, 20.04 and 22.04
    +sort=10003
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
