# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .quay_basic_auth import QuayBasicAuth
from .quay_integrations import QuayIntegrations


class QuayProviderAccount(UniversalBaseModel):
    """
    +label=Quay
    +icon=puzzle-piece
    """

    type: typing.Literal["provider-account/quay"] = pydantic.Field(default="provider-account/quay")
    """
    +value=provider-account/quay
    """

    name: str = pydantic.Field()
    """
    +uiProps={"disableEdit":true}
    +label=Name
    +usage=The name of the provider account.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    account_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Account Name
    +usage=The name of the account on Quay.
    +sort=200
    """

    auth_data: typing.Optional[QuayBasicAuth] = None
    integrations: typing.List[QuayIntegrations] = pydantic.Field()
    """
    +label=Integrations
    +usage=List of integrations that are associated with the provider account.
    +sort=400
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
