# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class RateLimitUnit(str, enum.Enum):
    """
    +usage=Unit for rate limit calculation
    """

    REQUESTS_PER_DAY = "requests_per_day"
    TOKENS_PER_MINUTE = "tokens_per_minute"
    REQUESTS_PER_MINUTE = "requests_per_minute"
    TOKENS_PER_DAY = "tokens_per_day"
    REQUESTS_PER_HOUR = "requests_per_hour"
    TOKENS_PER_HOUR = "tokens_per_hour"

    def visit(
        self,
        requests_per_day: typing.Callable[[], T_Result],
        tokens_per_minute: typing.Callable[[], T_Result],
        requests_per_minute: typing.Callable[[], T_Result],
        tokens_per_day: typing.Callable[[], T_Result],
        requests_per_hour: typing.Callable[[], T_Result],
        tokens_per_hour: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is RateLimitUnit.REQUESTS_PER_DAY:
            return requests_per_day()
        if self is RateLimitUnit.TOKENS_PER_MINUTE:
            return tokens_per_minute()
        if self is RateLimitUnit.REQUESTS_PER_MINUTE:
            return requests_per_minute()
        if self is RateLimitUnit.TOKENS_PER_DAY:
            return tokens_per_day()
        if self is RateLimitUnit.REQUESTS_PER_HOUR:
            return requests_per_hour()
        if self is RateLimitUnit.TOKENS_PER_HOUR:
            return tokens_per_hour()
