# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .samba_nova_integrations import SambaNovaIntegrations
from .samba_nova_key_auth import SambaNovaKeyAuth


class SambaNovaProviderAccount(UniversalBaseModel):
    """
    +label=SambaNova Provider Account
    +icon=sambanova
    """

    type: typing.Literal["provider-account/sambanova"] = pydantic.Field(default="provider-account/sambanova")
    """
    +value=provider-account/sambanova
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the SambaNova provider account
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    auth_data: SambaNovaKeyAuth
    integrations: typing.Optional[typing.List[SambaNovaIntegrations]] = pydantic.Field(default=None)
    """
    +label=Integrations
    +sort=300
    +usage=List of integrations that are associated with the SambaNova provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=400
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
