# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ScheduleConcurrencyPolicy(str, enum.Enum):
    """
    +usage=Choose whether to allow this job to run while another instance of the job is running, or to replace the currently running instance. Allow
    will enable multiple instances of this job to run. Forbid will keep the current instance of the job running and stop a new instance from being run.
    Replace will terminate any currently running instance of the job and start a new one.
    """

    FORBID = "Forbid"
    ALLOW = "Allow"
    REPLACE = "Replace"

    def visit(
        self,
        forbid: typing.Callable[[], T_Result],
        allow: typing.Callable[[], T_Result],
        replace: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ScheduleConcurrencyPolicy.FORBID:
            return forbid()
        if self is ScheduleConcurrencyPolicy.ALLOW:
            return allow()
        if self is ScheduleConcurrencyPolicy.REPLACE:
            return replace()
