# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .subject import Subject


class Secret(UniversalBaseModel):
    id: str
    fqn: str
    name: str
    secret_group_id: typing_extensions.Annotated[str, FieldMetadata(alias="secretGroupId")]
    value: typing.Optional[str] = None
    created_by_subject: typing_extensions.Annotated[
        typing.Optional[Subject], FieldMetadata(alias="createdBySubject")
    ] = None
    created_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAt")] = None
    updated_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="updatedAt")] = None
    secret_versions: typing_extensions.Annotated[
        typing.Optional[typing.List["SecretVersion"]], FieldMetadata(alias="secretVersions")
    ] = None
    active_deployments_count: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="activeDeploymentsCount")
    ] = None
    created_by: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="createdBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


from .secret_version import SecretVersion  # noqa: E402, F401, I001

update_forward_refs(Secret)
