# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .custom_tls_settings import CustomTlsSettings
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType
from .self_hosted_model_auth_data import SelfHostedModelAuthData
from .self_hosted_model_model_server import SelfHostedModelModelServer


class SelfHostedModel(UniversalBaseModel):
    """
    +label=Self Hosted Model Integration
    +icon=puzzle-piece
    """

    type: typing.Literal["integration/model/self-hosted-model"] = pydantic.Field(
        default="integration/model/self-hosted-model"
    )
    """
    +value=integration/model/self-hosted-model
    """

    name: str = pydantic.Field()
    """
    +sort=1
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    hosted_model_name: str = pydantic.Field()
    """
    +label=Hosted Model Name
    +sort=2
    +usage=The name of the hosted model
    """

    url: str = pydantic.Field()
    """
    +sort=3
    +message=enter valid https/http URL that should not end with trailing slash
    """

    model_server: SelfHostedModelModelServer = pydantic.Field()
    """
    +sort=4
    +label=Model Server Type
    +usage=The type of model server being used
    """

    tfy_application_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    +uiType=Hidden
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +usage=Specify the type of the model
    +sort=4
    +uiProps={"disableAllOption": true}
    """

    tls_settings: typing.Optional[CustomTlsSettings] = None
    auth_data: typing.Optional[SelfHostedModelAuthData] = pydantic.Field(default=None)
    """
    +label=Auth Data
    +usage=SelfHostedModel authentication data for the integration.
    +sort=300
    """

    headers: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +label=SelfHostedModel Headers
    +usage=SelfHostedModel headers for the integration. Forwarded to the provider as is. For example: `{"Authorization": "APIKey <token>"}`
    +sort=500
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=600
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
