# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .self_hosted_model_integrations import SelfHostedModelIntegrations


class SelfHostedModelProviderAccount(UniversalBaseModel):
    """
    +label=Self Hosted
    +icon=puzzle-piece
    """

    type: typing.Literal["provider-account/self-hosted-model"] = pydantic.Field(
        default="provider-account/self-hosted-model"
    )
    """
    +value=provider-account/self-hosted-model
    """

    name: str = pydantic.Field()
    """
    +uiProps={"disableEdit":true}
    +label=Name
    +usage=The name of the provider account.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    integrations: typing.List[SelfHostedModelIntegrations] = pydantic.Field()
    """
    +label=Integrations
    +usage=List of integrations that are associated with the provider account.
    +sort=400
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=200
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
