# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .slack_integrations import SlackIntegrations


class SlackProviderAccount(UniversalBaseModel):
    """
    +label=Slack Provider Account
    +icon=slack
    """

    type: typing.Literal["provider-account/slack"] = pydantic.Field(default="provider-account/slack")
    """
    +value=provider-account/slack
    """

    name: str = pydantic.Field()
    """
    +uiProps={"disableEdit":false}
    +label=Name
    +usage=The name of the provider account.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    integrations: typing.List[SlackIntegrations] = pydantic.Field()
    """
    +label=Integrations
    +usage=List of integrations that are associated with the provider account.
    +sort=400
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
