# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SmtpCredentials(UniversalBaseModel):
    """
    +label=SMTP Credentials
    """

    type: typing.Literal["smtp-credentials"] = pydantic.Field(default="smtp-credentials")
    """
    +value=smtp-credentials
    +sort=250
    """

    host: str = pydantic.Field()
    """
    +label=Host
    +usage=The SMTP host of the email server.
    +sort=300
    """

    username: str = pydantic.Field()
    """
    +label=Username
    +usage=The username for the SMTP server.
    +sort=400
    """

    password: str = pydantic.Field()
    """
    +label=Password
    +usage=The password for the SMTP server.
    +sort=500
    +uiType=Password
    """

    port: int = pydantic.Field(default=587)
    """
    +label=Port
    +usage=The port of the SMTP server.
    +sort=600
    """

    tls: bool = pydantic.Field(default=True)
    """
    +label=TLS
    +usage=Whether to use TLS for the SMTP server.
    +sort=700
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
