# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SparkBuild(UniversalBaseModel):
    """
    +docs=Describes that we are using python to build a container image with a specific python version and pip packages installed.
    +label=Build specification
    +icon=fa-brands fa-python:#306998
    """

    type: typing.Literal["tfy-spark-buildpack"] = pydantic.Field(default="tfy-spark-buildpack")
    """
    +value=tfy-spark-buildpack
    """

    spark_version: str = pydantic.Field(default="3.5.2")
    """
    --- Spark Specific Field ---
    +label=Spark Version
    +usage=Spark version should match the spark version installed in the image.
    +sort=1001
    """

    build_context_path: str = pydantic.Field(default="./")
    """
    +label=Path to build context
    +usage=Build path relative to project root path.
    """

    requirements_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    `Path to build context`
    +label=Path to requirements
    +usage=Path to `requirements.txt` relative to
    `Path to build context`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
