# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SparkImage(UniversalBaseModel):
    """
    +docs=Describes that we are using a pre-built image stored in a Docker Image registry
    +label=Deploy an existing image
    +icon=fa-brands fa-docker:#0db7ed
    """

    type: typing.Literal["spark-image"] = pydantic.Field(default="spark-image")
    """
    +value=spark-image
    """

    spark_version: str = pydantic.Field(default="3.5.2")
    """
    --- Spark Specific Field ---
    +label=Spark Version
    +usage=Spark version should match the spark version installed in the image.
    +sort=1000
    """

    image_uri: str = pydantic.Field()
    """
    +label=Image URI
    +usage=The image URI. Specify the name of the image and the tag.
    If the image is in Dockerhub, you can skip registry-url (for e.g. `tensorflow/tensorflow`).
    You can use an image from a private registry using Advanced fields
    +placeholder=registry-url/account/image:version (e.g. docker.io/tensorflow/tensorflow)
    +sort=1001
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    +docs=FQN of the container registry. You can the FQN of your desired container registry (or add one)
    in the  Integrations page[Integrations](https://app.truefoundry.tech/integrations?tab=docker-registry) page
    +label=Docker Registry
    +usage=FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    +sort=1002
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
