# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .spark_driver_config import SparkDriverConfig
from .spark_executor_config import SparkExecutorConfig
from .spark_job_entrypoint import SparkJobEntrypoint
from .spark_job_image import SparkJobImage
from .volume_mount import VolumeMount


class SparkJob(UniversalBaseModel):
    type: typing.Literal["spark-job"] = pydantic.Field(default="spark-job")
    """
    +value=spark-job
    +sort=1
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +usage=Name of the job
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +sort=2
    """

    image: SparkJobImage = pydantic.Field()
    """
    +label=Deploy a Docker image & Specify Spark Version
    +usage=The image to use for driver and executors. Must have spark installed. Spark version must match the version in the image.
    +sort=500
    """

    entrypoint: SparkJobEntrypoint = pydantic.Field()
    """
    +label=Entrypoint
    +sort=1000
    """

    driver_config: SparkDriverConfig
    executor_config: SparkExecutorConfig
    env: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    +label=Environment Variables
    +usage=Configure environment variables to be injected in the service either as plain text. [Docs](https://docs.truefoundry.com/docs/env-variables)
    +icon=fa-globe
    +sort=21000
    """

    spark_conf: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    +label=Spark Config Properties
    +usage=Extra configuration properties to be passed to the spark job. [Docs](https://spark.apache.org/docs/latest/configuration.html)
    +icon=fa-gear:#68BBE3
    +sort=21500
    """

    mounts: typing.Optional[typing.List[VolumeMount]] = pydantic.Field(default=None)
    """
    +label=Mounts
    +usage=Configure volumes to be mounted to driver and executors. [Docs](https://docs.truefoundry.com/docs/mounting-volumes-job)
    +sort=22000
    +uiType=Mounts
    """

    retries: typing.Optional[int] = pydantic.Field(default=0)
    """
    +label=Retries
    +usage=Specify the maximum number of attempts to retry a job before it is marked as failed.
    +icon=fa-repeat
    +sort=23000
    """

    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Service Account
    +sort=24000
    """

    workspace_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Workspace FQN
    +docs=Fully qualified name of the workspace
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
