# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SparkJobPythonEntrypoint(UniversalBaseModel):
    """
    +label=python
    """

    type: typing.Literal["python"] = pydantic.Field(default="python")
    """
    +value=python
    """

    main_application_file: str = pydantic.Field()
    """
    +label=Main Application File
    +usage=The main application file to be executed by the spark job. Relative path in case of git repository.
    +message=Filename should have .py extension
    +sort=5
    +placeholder=For example: local:///path/to/file.py, s3:///bucket/path/to/file.py, etc.
    """

    arguments: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Arguments
    +usage=Arguments to be passed to the main application file.
    +sort=6
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
