# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_access_key_auth import AwsAccessKeyAuth


class SqsOutputConfig(UniversalBaseModel):
    """
    +docs=Describes the configuration for the output SQS worker
    +label=SQS
    """

    type: typing.Literal["sqs"] = pydantic.Field(default="sqs")
    """
    +value=sqs
    """

    queue_url: str = pydantic.Field()
    """
    +label=Queue URL
    +usage=AWS SQS Queue URL of Publisher
    +sort=1
    """

    region_name: str = pydantic.Field()
    """
    +label=Region Name
    +usage=AWS Region Name
    +sort=2
    """

    auth: AwsAccessKeyAuth

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
