# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SshServerConfig(UniversalBaseModel):
    base_domain: str = pydantic.Field()
    """
    +label=SSH Base Domain
    +usage=The base domain for the cluster with which you can access your SSH containers
    +sort=1000
    +message=Must not contain any spaces.
    """

    port: float = pydantic.Field()
    """
    +label=SSH Port
    +usage=The port for the cluster with which you can access your SSH containers
    +sort=2000
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
