# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SsoTeamManifest(UniversalBaseModel):
    type: typing.Literal["sso-team"] = pydantic.Field(default="sso-team")
    """
    +value=sso-team
    """

    name: str = pydantic.Field()
    """
    +sort=100
    +message=Use of only alpha numeric character and "-" is allowed as team name and must be less than 25 characters
    +usage=Name of the Team
    """

    sso_name: str = pydantic.Field()
    """
    +sort=200
    +label=SSO
    +usage=SSO configuration to use for this team
    +uiType=Select
    """

    group_name: str = pydantic.Field()
    """
    +sort=300
    +label=Group Name
    +usage=Group name from SSO that will be used to determine team membership
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
