# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .subject_type import SubjectType


class Subject(UniversalBaseModel):
    subject_id: typing_extensions.Annotated[str, FieldMetadata(alias="subjectId")] = pydantic.Field()
    """
    Subject ID
    """

    subject_type: typing_extensions.Annotated[SubjectType, FieldMetadata(alias="subjectType")] = pydantic.Field()
    """
    Subject type
    """

    subject_slug: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="subjectSlug")] = (
        pydantic.Field(default=None)
    )
    """
    Subject slug
    """

    subject_display_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="subjectDisplayName")
    ] = pydantic.Field(default=None)
    """
    Subject display name
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
