# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TaskDockerFileBuild(UniversalBaseModel):
    """
    +docs=Describes the configuration for the docker build for a task
    +label=Docker File
    +icon=fa-brands fa-docker:#0db7ed
    """

    type: typing.Literal["task-dockerfile-build"] = pydantic.Field(default="task-dockerfile-build")
    """
    +value=dockerfile
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    +docs=FQN of the container registry. You can the FQN of your desired container registry (or add one)
    in the  Integrations page[Integrations](https://app.truefoundry.tech/integrations?tab=docker-registry) page
    +label=Docker Registry
    +usage=FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    dockerfile_path: str = pydantic.Field(default="./Dockerfile")
    """
    +label=Path to Dockerfile
    +usage=The file path of the Dockerfile relative to project root path.
    """

    build_args: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +label=Build arguments to pass to docker build
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
