# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TaskPySparkBuild(UniversalBaseModel):
    """
    +docs=Describes the configuration for the PySpark build for a task
    +label=PySpark Build Spec
    +icon=fa-brands fa-python:#306998
    """

    type: typing.Literal["task-pyspark-build"] = pydantic.Field(default="task-pyspark-build")
    """
    +value=task-pyspark-build
    """

    spark_version: str = pydantic.Field(default="3.5.2")
    """
    --- Spark Specific Field ---
    +label=Spark Version
    +usage=Spark version should match the spark version installed in the image.
    +sort=1001
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    +docs=FQN of the container registry. You can the FQN of your desired container registry (or add one)
    in the  Integrations page[Integrations](https://app.truefoundry.tech/integrations?tab=docker-registry) page
    +label=Docker Registry
    +usage=FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    requirements_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    `Path to build context`
    +label=Path to requirements
    +usage=Path to `requirements.txt` relative to
    `Path to build context`
    """

    pip_packages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Pip packages to install
    +usage=Define pip package requirements.
    In Python/YAML E.g. ["fastapi>=0.90,<1.0", "uvicorn"]
    +placeholder=Enter a pip package name E.g. fastapi>=0.90,<1.0
    """

    apt_packages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=List of Debian packages to install.
    +usage=Debian packages to install via `apt get`.
    In Python/YAML E.g. ["git", "ffmpeg", "htop"]
    +placeholder=Enter a debian package name E.g. ffmpeg
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
