# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TeamManifest(UniversalBaseModel):
    type: typing.Literal["team"] = pydantic.Field(default="team")
    """
    +value=team
    """

    name: str = pydantic.Field()
    """
    +sort=1
    +message=Use of only alpha numeric character and "-" is allowed as team name and must be less than 25 characters
    +usage=Name of the Team
    """

    managers: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +sort=3
    +label=Team Managers
    +usage=Emails of each of the user who can manage the members of the team. Any tenant admin is by default a team manager.
    +uiType=UserSelect
    +uiProps={"optionTypes": ["users"]}
    """

    members: typing.List[str] = pydantic.Field()
    """
    +sort=4
    +label=Team Members
    +usage=Enter email of each of the user you want to add in the team.
    +uiType=UserSelect
    +uiProps={"optionTypes": ["users"]}
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
