# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .tool_message_content import ToolMessageContent


class ToolMessage(UniversalBaseModel):
    """
    Tool message for the chat
    """

    role: typing.Literal["tool"] = pydantic.Field(default="tool")
    """
    Role of the message
    """

    content: ToolMessageContent = pydantic.Field()
    """
    Content of the tool call result
    """

    tool_call_id: str = pydantic.Field()
    """
    Unique identifier for the tool call
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
