# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .subject import Subject


class TraceSpan(UniversalBaseModel):
    span_id: typing_extensions.Annotated[str, FieldMetadata(alias="spanId")]
    trace_id: typing_extensions.Annotated[str, FieldMetadata(alias="traceId")]
    parent_span_id: typing_extensions.Annotated[str, FieldMetadata(alias="parentSpanId")]
    service_name: typing_extensions.Annotated[str, FieldMetadata(alias="serviceName")]
    span_name: typing_extensions.Annotated[str, FieldMetadata(alias="spanName")]
    span_kind: typing_extensions.Annotated[str, FieldMetadata(alias="spanKind")]
    scope_name: typing_extensions.Annotated[str, FieldMetadata(alias="scopeName")]
    scope_version: typing_extensions.Annotated[str, FieldMetadata(alias="scopeVersion")]
    timestamp: str = pydantic.Field()
    """
    Timestamp in ISO 8601 format (e.g., 2025-03-12T00:00:09.872Z).
    """

    duration: float
    status_code: typing_extensions.Annotated[str, FieldMetadata(alias="statusCode")]
    status_message: typing_extensions.Annotated[str, FieldMetadata(alias="statusMessage")]
    span_attributes: typing_extensions.Annotated[
        typing.Dict[str, typing.Optional[typing.Any]], FieldMetadata(alias="spanAttributes")
    ]
    events: typing.List[typing.Dict[str, typing.Optional[typing.Any]]]
    created_by_subject: typing_extensions.Annotated[Subject, FieldMetadata(alias="createdBySubject")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
