# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .virtual_mcp_server_source import VirtualMcpServerSource


class VirtualMcpServerIntegration(UniversalBaseModel):
    """
    +label=Virtual MCP Server
    +icon=puzzle-piece
    """

    type: typing.Literal["integration/mcp-server/virtual"] = pydantic.Field(default="integration/mcp-server/virtual")
    """
    +value=integration/mcp-server/virtual
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +usage=The name of the Virtual MCP Server.
    +sort=100
    """

    description: str = pydantic.Field()
    """
    +label=Description
    +usage=Provide a brief description of the purpose of this Virtual MCP Server.
    +uiType=TextArea
    +message=1 to 1000 characters long, may contain any character except newlines
    +sort=200
    +uiProps={"descriptionInline":true}
    """

    servers: typing.List[VirtualMcpServerSource] = pydantic.Field()
    """
    +label=Source MCP Servers
    +usage=List of source MCP servers to include in this virtual server.
    +sort=300
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of teams/users who can use this MCP server.
    +sort=400
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
