# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .mcp_server_header_override_auth import McpServerHeaderOverrideAuth


class VirtualMcpServerSource(UniversalBaseModel):
    """
    +label=Virtual MCP Server Source
    """

    name: str = pydantic.Field()
    """
    +label=Server Name
    +usage=Name of the source MCP server within this group (use {provider_account_name}/{integration_name} format).
    +sort=100
    """

    enabled_tools: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Enabled Tools
    +usage=List of tools to enable from this source server. Leave empty to enable all tools.
    +sort=200
    """

    auth_data: typing.Optional[McpServerHeaderOverrideAuth] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
