# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .volume_browser import VolumeBrowser
from .volume_config import VolumeConfig


class Volume(UniversalBaseModel):
    type: typing.Literal["volume"] = pydantic.Field(default="volume")
    """
    +value=volume
    """

    name: str = pydantic.Field()
    """
    +sort=1
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +usage=Name of the Volume. This will be set as the volume name.
    """

    config: VolumeConfig = pydantic.Field()
    """
    +sort=2
    +label=Volume Config
    +message=Volume Configuration, can be either Dynamically provisioned or statically provisioned.
    """

    volume_browser: typing.Optional[VolumeBrowser] = None
    workspace_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Workspace FQN
    +docs=Fully qualified name of the workspace
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
