# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .endpoint import Endpoint


class VolumeBrowser(UniversalBaseModel):
    """
    +label=Volume Browser
    """

    username: typing.Optional[str] = pydantic.Field(default=None)
    """
    +message=3 to 10 lower case characters long alphanumeric word, may contain - in between, cannot start with a number.
    +usage=Username for logging in the volume browser.
    +sort=1
    """

    password_secret_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Password Secret FQN
    +usage=TFY Secret containing the password for logging in the volume browser.
    +sort=2
    """

    endpoint: Endpoint
    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Service Account Name
    +usage=Kubernetes Service account name for the volume browser.
    +sort=4
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
