# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class VolumeMount(UniversalBaseModel):
    type: typing.Literal["volume"] = pydantic.Field(default="volume")
    """
    +value=volume
    """

    mount_path: str = pydantic.Field()
    """
    +label=Volume mount path
    +usage=Absolute file path where the volume will be mounted.
    +message=Please enter a valid mount path
    """

    sub_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Sub Path
    +usage=Sub path within the volume to mount. Defaults to root of the volume.
    """

    volume_fqn: str = pydantic.Field()
    """
    +label=Volume
    +usage=The TrueFoundry volume that needs to be mounted.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
