# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .webhook_integration_auth_data import WebhookIntegrationAuthData


class WebhookIntegration(UniversalBaseModel):
    """
    +label=Webhook Integration
    +icon=https://assets.production.truefoundry.com/webhook.svg
    """

    type: typing.Literal["integration/gateway-request-logger/webhook"] = pydantic.Field(
        default="integration/gateway-request-logger/webhook"
    )
    """
    +value=integration/gateway-request-logger/webhook
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +uiProps={"disableEdit":true}
    +usage=The name of the integration that will be displayed in the TrueFoundry UI.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    webhook_url: str = pydantic.Field()
    """
    +label=Webhook URL
    +usage=The URL of the webhook endpoint
    +sort=200
    """

    auth_data: typing.Optional[WebhookIntegrationAuthData] = pydantic.Field(default=None)
    """
    +label=Authentication
    +usage=Authentication configuration for the webhook
    +sort=300
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=10005
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
