# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .webhook_integrations import WebhookIntegrations


class WebhookProviderAccount(UniversalBaseModel):
    """
    +label=Webhook Provider Account
    +icon=webhook
    """

    type: typing.Literal["provider-account/webhook"] = pydantic.Field(default="provider-account/webhook")
    """
    +value=provider-account/webhook
    """

    name: str = pydantic.Field()
    """
    +uiProps={"disableEdit":true}
    +label=Name
    +usage=The name of the provider account.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    integrations: typing.List[WebhookIntegrations] = pydantic.Field()
    """
    +label=Integrations
    +usage=List of integrations that are associated with the provider account.
    +sort=400
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
