# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class WorkbenchImage(UniversalBaseModel):
    """
    +usage=Workbench Image with persistent environment (Python 3.11.6)
    """

    image_uri: str = pydantic.Field()
    """
    +label=Image URI
    +usage=The image URI. Specify the name of the image and the tag.
    If the image is in Dockerhub, you can skip registry-url (for e.g. `tensorflow/tensorflow`).
    You can use an image from a private registry using Advanced fields
    +placeholder=registry-url/account/image:version
    """

    build_script: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Build Script
    +usage=The build script to run when building the image.
    This will be executed as the last step in the docker build process as the root user (RUN DEBIAN_FRONTEND=noninteractive bash -ex build_script.sh)
    +placeholder=Enter the build script
    +uiType=CodeEditor
    +uiProps={"language":"shell"}
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    +docs=FQN of the container registry. You can the FQN of your desired container registry (or add one)
    in the  Integrations page[Integrations](https://app.truefoundry.tech/integrations?tab=docker-registry) page
    +label=Docker Registry
    +uiType=IntegrationSelect
    +uiProps={"integrationType":"docker-registry"}
    +usage=FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
