# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .workflow_alert import WorkflowAlert
from .workflow_flyte_entities_item import WorkflowFlyteEntitiesItem
from .workflow_source import WorkflowSource


class Workflow(UniversalBaseModel):
    """
    +docs=Describes the configuration for the worflow
    """

    type: typing.Literal["workflow"] = pydantic.Field(default="workflow")
    """
    +value=workflow
    """

    name: str = pydantic.Field()
    """
    +usage=Name of the workflow
    +sort=1
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    source: WorkflowSource = pydantic.Field()
    """
    +docs=Source Code for the workflow, either local or remote
    +label=Source Code for your workflow
    +icon=fa-solid fa-cloud-arrow-up:#21B6A8
    +sort=200
    """

    workflow_file_path: str = pydantic.Field()
    """
    +label=Workflow File Path
    +docs=Path to the workflow file relative to the project root path
    +sort=550
    """

    flyte_entities: typing.Optional[typing.List[WorkflowFlyteEntitiesItem]] = pydantic.Field(default=None)
    """
    +label=Flyte Entities
    """

    alerts: typing.Optional[typing.List[WorkflowAlert]] = pydantic.Field(default=None)
    """
    +label=Alerts
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
